/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.types.NamedLocationStorage;
import com.fibermc.essentialcommands.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public final class PlayerDataFactory {
    private PlayerDataFactory() {
    }

    private static PlayerData create(class_3222 player, File playerDataFile) {
        PlayerData pData = new PlayerData(player, playerDataFile);
        boolean fileExisted = false;
        try {
            fileExisted = !playerDataFile.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (fileExisted && playerDataFile.length() != 0L) {
            try {
                pData.fromNbt(class_2507.method_30613((Path)playerDataFile.toPath(), (class_2505)class_2505.method_53898()), (class_7225.class_7874)class_5455.field_40585);
            }
            catch (IOException e) {
                EssentialCommands.log(Level.WARN, "Failed to load essential_commands player data for {%s}", player.method_5477().getString());
                e.printStackTrace();
            }
        } else {
            pData.method_80();
            pData.save((class_7225.class_7874)class_5455.field_40585);
        }
        return pData;
    }

    public static PlayerData create(NamedLocationStorage homes, File saveFile) {
        String fileName = saveFile.getName();
        UUID playerUuid = UUID.fromString(fileName.substring(0, fileName.indexOf(".dat")));
        PlayerData pData = new PlayerData(playerUuid, saveFile);
        if (Files.exists(saveFile.toPath(), new LinkOption[0]) && saveFile.length() != 0L) {
            try {
                class_2487 nbtCompound3 = class_2507.method_30613((Path)saveFile.toPath(), (class_2505)class_2505.method_53898());
                pData.fromNbt(nbtCompound3, (class_7225.class_7874)class_5455.field_40585);
                pData.homes.putAll(homes);
            }
            catch (IOException e) {
                EssentialCommands.log(Level.WARN, "Failed to load essential_commands player data for {" + String.valueOf(playerUuid) + "}", new Object[0]);
                e.printStackTrace();
            }
        } else {
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        pData.method_80();
        return pData;
    }

    public static PlayerData create(class_3222 player) {
        try {
            return PlayerDataFactory.create(player, PlayerDataFactory.getPlayerDataFile(player));
        }
        catch (IOException ex) {
            EssentialCommands.log(Level.ERROR, "Failed to create player data file for player with id '{}'. Player data may fail to save, or other unexpected behavior may occur.", player.method_5845());
            EssentialCommands.LOGGER.error((Object)ex);
            return new PlayerData(player, null);
        }
    }

    public static Path getPlayerDataDirectoryPath(MinecraftServer server) throws IOException {
        return FileUtil.getOrCreateWorldDirectory(server, "modplayerdata");
    }

    private static File getPlayerDataFile(class_3222 player) throws IOException {
        return PlayerDataFactory.getPlayerDataDirectoryPath(player.method_5682()).resolve(player.method_5845() + ".dat").toFile();
    }
}

