/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.IServerPlayerEntityData;
import com.fibermc.essentialcommands.types.IStyleProvider;
import com.fibermc.essentialcommands.types.ProfileOption;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jpcode.eccore.config.ConfigUtil;
import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfile
extends class_18
implements IServerPlayerEntityData,
IStyleProvider {
    private class_3222 player;
    private final File saveFile;
    private ProfileOptions profileOptions;
    public static final Map<String, ProfileOption<?>> OPTIONS = Map.ofEntries(new AbstractMap.SimpleEntry<String, ProfileOption<Boolean>>("printTeleportCoordinates", new ProfileOption<Boolean>((ArgumentType<Boolean>)BoolArgumentType.bool(), false, (context, name, profile) -> {
        profile.profileOptions.printTeleportCoordinates = Optional.of(BoolArgumentType.getBool((CommandContext)context, (String)name));
    }, profile -> profile.profileOptions.printTeleportCoordinates)), new AbstractMap.SimpleEntry<String, ProfileOption<Object>>("formattingDeault", new ProfileOption<Object>((ArgumentType<Object>)StringArgumentType.greedyString(), null, (context, name, profile) -> {
        profile.profileOptions.formattingDefault = Optional.ofNullable(ConfigUtil.parseStyle((String)StringArgumentType.getString((CommandContext)context, (String)name)));
    }, profile -> profile.profileOptions.formattingDefault.map(ConfigUtil::serializeStyle))), new AbstractMap.SimpleEntry<String, ProfileOption<Object>>("formattingAccent", new ProfileOption<Object>((ArgumentType<Object>)StringArgumentType.greedyString(), null, (context, name, profile) -> {
        profile.profileOptions.formattingAccent = Optional.ofNullable(ConfigUtil.parseStyle((String)StringArgumentType.getString((CommandContext)context, (String)name)));
    }, profile -> profile.profileOptions.formattingAccent.map(ConfigUtil::serializeStyle))));

    public PlayerProfile(@NotNull class_3222 player, File saveFile) {
        this.player = player;
        this.saveFile = saveFile;
        this.profileOptions = new ProfileOptions();
    }

    public Optional<Boolean> shouldPrintTeleportCoordinates() {
        return this.profileOptions.printTeleportCoordinates;
    }

    @Override
    @Nullable
    public class_2583 getFormattingDefault() {
        return this.profileOptions.formattingDefault.orElse(null);
    }

    @Override
    @Nullable
    public class_2583 getFormattingAccent() {
        return this.profileOptions.formattingAccent.orElse(null);
    }

    @Override
    @Nullable
    public class_2583 getFormattingError() {
        return this.profileOptions.formattingError.orElse(null);
    }

    public void fromNbt(class_2487 tag) {
        class_2487 dataTag = tag.method_10562("data");
        this.profileOptions = new ProfileOptions();
        this.profileOptions.formattingDefault = Optional.ofNullable(dataTag.method_10580("formattingDeault")).map(class_2520::method_10714).map(ConfigUtil::parseStyle);
        this.profileOptions.formattingAccent = Optional.ofNullable(dataTag.method_10580("formattingAccent")).map(class_2520::method_10714).map(ConfigUtil::parseStyle);
        this.profileOptions.formattingError = Optional.ofNullable(dataTag.method_10580("formattingError")).map(class_2520::method_10714).map(ConfigUtil::parseStyle);
        this.profileOptions.printTeleportCoordinates = dataTag.method_10545("printTeleportCoordinates") ? Optional.of(dataTag.method_10577("printTeleportCoordinates")) : Optional.empty();
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        this.profileOptions.formattingDefault.ifPresent(style -> tag.method_10582("formattingDeault", ConfigUtil.serializeStyle((class_2583)style)));
        this.profileOptions.formattingAccent.ifPresent(style -> tag.method_10582("formattingAccent", ConfigUtil.serializeStyle((class_2583)style)));
        this.profileOptions.formattingError.ifPresent(style -> tag.method_10582("formattingError", ConfigUtil.serializeStyle((class_2583)style)));
        this.profileOptions.printTeleportCoordinates.ifPresent(printTeleportCoordinates -> tag.method_10556("printTeleportCoordinates", printTeleportCoordinates.booleanValue()));
        return tag;
    }

    public void save(class_7225.class_7874 wrapperLookup) {
        super.method_17919(this.saveFile, wrapperLookup);
    }

    @Override
    public class_3222 getPlayer() {
        return this.player;
    }

    @Override
    public void updatePlayerEntity(class_3222 newPlayerEntity) {
        this.player = newPlayerEntity;
    }

    public static PlayerProfile access(@NotNull class_3222 player) {
        return ((ServerPlayerEntityAccess)player).ec$getProfile();
    }

    public static PlayerProfile accessFromContextOrThrow(CommandContext<class_2168> context) throws CommandSyntaxException {
        return PlayerProfile.access(((class_2168)context.getSource()).method_9207());
    }

    private static final class ProfileOptions {
        private Optional<class_2583> formattingDefault = Optional.empty();
        private Optional<class_2583> formattingAccent = Optional.empty();
        private Optional<class_2583> formattingError = Optional.empty();
        private Optional<Boolean> printTeleportCoordinates = Optional.empty();

        private ProfileOptions() {
        }
    }

    private static final class StorageKey {
        static final String FORMATTING_DEAULT = "formattingDeault";
        static final String FORMATTING_ACCENT = "formattingAccent";
        static final String FORMATTING_ERROR = "formattingError";
        static final String PRINT_TELEPORT_COORDINATES = "printTeleportCoordinates";

        private StorageKey() {
        }
    }
}

