/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.teleportation;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.teleportation.QueuedLocationTeleport;
import com.fibermc.essentialcommands.teleportation.QueuedTeleport;
import com.fibermc.essentialcommands.teleportation.TeleportManager;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import dev.jpcode.eccore.util.TextUtil;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public final class PlayerTeleporter {
    private PlayerTeleporter() {
    }

    public static void requestTeleport(PlayerData pData, MinecraftLocation dest, class_5250 destName) {
        PlayerTeleporter.requestTeleport(new QueuedLocationTeleport(pData, dest, destName));
    }

    public static void requestTeleport(QueuedTeleport queuedTeleport) {
        class_3222 player = queuedTeleport.getPlayerData().getPlayer();
        PlayerData pData = queuedTeleport.getPlayerData();
        if (pData.getTpCooldown() > 0 && !PlayerTeleporter.playerHasTpRulesBypass(player, "essentialcommands.bypass.teleport_delay")) {
            int remainingCooldown = (int)Math.ceil((double)pData.getTpCooldown() / 20.0);
            pData.sendError("teleport.error.cooldown", class_2561.method_30163((String)String.valueOf(remainingCooldown)));
            return;
        }
        if (PlayerTeleporter.playerHasTpRulesBypass(player, "essentialcommands.bypass.teleport_delay") || EssentialCommands.CONFIG.TELEPORT_DELAY_TICKS <= 0) {
            PlayerTeleporter.teleport(pData, queuedTeleport.getDest(), queuedTeleport.getDestName());
        } else {
            TeleportManager.getInstance().queueTeleport(queuedTeleport);
        }
    }

    public static void requestTeleport(class_3222 playerEntity, MinecraftLocation dest, class_5250 destName) {
        PlayerTeleporter.requestTeleport(((ServerPlayerEntityAccess)playerEntity).ec$getPlayerData(), dest, destName);
    }

    public static void teleport(QueuedTeleport queuedTeleport) {
        queuedTeleport.complete();
        PlayerTeleporter.teleport(queuedTeleport.getPlayerData(), queuedTeleport.getDest(), queuedTeleport.getDestName());
    }

    public static void teleport(PlayerData pData, MinecraftLocation dest, class_5250 destName) {
        class_3222 player = pData.getPlayer();
        if (!EssentialCommands.CONFIG.ALLOW_TELEPORT_BETWEEN_DIMENSIONS && !PlayerTeleporter.playerHasTpRulesBypass(player, "essentialcommands.bypass.allow_teleport_between_dimensions") && dest.dim() != player.method_37908().method_27983()) {
            pData.sendError("teleport.error.interdimensional_teleport_disabled", new class_2561[0]);
            return;
        }
        PlayerTeleporter.execTeleport(player, dest, destName);
    }

    private static void execTeleport(class_3222 playerEntity, MinecraftLocation dest, class_5250 destName) {
        class_3218 targetWorld = playerEntity.method_5682().method_3847(dest.dim());
        if (targetWorld == null) {
            throw new NullPointerException(String.format("Could not find teleport target world, '%s'", dest.dim()));
        }
        playerEntity.method_14251(targetWorld, dest.pos().field_1352, dest.pos().field_1351, dest.pos().field_1350, dest.headYaw(), dest.pitch());
        ServerPlayerEntityAccess playerAccess = (ServerPlayerEntityAccess)playerEntity;
        PlayerProfile playerProfile = playerAccess.ec$getProfile();
        playerAccess.ec$getPlayerData().sendMessage("teleport.done", new class_2561[]{playerProfile.shouldPrintTeleportCoordinates().orElse(EssentialCommands.CONFIG.PRINT_TELEPORT_COORDINATES) != false ? TextUtil.join((class_2561[])new class_2561[]{destName, dest.toText(playerProfile)}, (class_2561)class_2561.method_43470((String)" ")) : destName});
        TeleportManager.getInstance().startTpCooldown(playerEntity);
    }

    static boolean playerHasTpRulesBypass(class_3222 player, String permission) {
        return player.method_5687(4) && EssentialCommands.CONFIG.OPS_BYPASS_TELEPORT_RULES || ECPerms.check((class_2172)player.method_5671(), permission, 5);
    }
}

