/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.WarpLocation;
import com.fibermc.essentialcommands.types.WarpStorage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class WorldDataManager
extends class_18 {
    private final WarpStorage warps;
    private MinecraftLocation spawnLocation = null;
    private Path saveDir;
    private File worldDataFile;
    private static final String SPAWN_KEY = "spawn";
    private static final String WARPS_KEY = "warps";
    public final Event<Consumer<WarpStorage>> warpsLoadEvent = EventFactory.createArrayBacked(Consumer.class, listeners -> warps -> {
        for (Consumer event : listeners) {
            event.accept(warps);
        }
    });

    public WorldDataManager() {
        this.warps = new WarpStorage();
    }

    public static WorldDataManager createForServer(MinecraftServer server) {
        WorldDataManager worldDataManager = new WorldDataManager();
        worldDataManager.onServerStart(server);
        return worldDataManager;
    }

    public void onServerStart(MinecraftServer server) {
        this.saveDir = server.method_27050(class_5218.field_24188).resolve("essentialcommands");
        try {
            Files.createDirectories(this.saveDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.worldDataFile = this.saveDir.resolve("world_data.dat").toFile();
        try {
            boolean fileExisted;
            boolean bl = fileExisted = !this.worldDataFile.createNewFile();
            if (fileExisted && this.worldDataFile.length() > 0L) {
                this.fromNbt(class_2507.method_30613((File)this.worldDataFile).method_10562("data"));
            } else {
                this.method_80();
                this.save();
            }
        }
        catch (IOException e) {
            EssentialCommands.log(Level.ERROR, String.format("An unexpected error occoured while loading the Essential Commands World Data file (Path: '%s')", this.worldDataFile.getPath()), new Object[0]);
            e.printStackTrace();
        }
    }

    private File getDataFile() {
        return this.worldDataFile;
    }

    public void fromNbt(class_2487 tag) {
        MinecraftLocation tempSpawnLocation = MinecraftLocation.fromNbt(tag.method_10562(SPAWN_KEY));
        this.spawnLocation = tempSpawnLocation.dim().method_29177().method_12832().isEmpty() ? null : tempSpawnLocation;
        class_2487 warpsNbt = tag.method_10562(WARPS_KEY);
        this.warps.loadNbt((class_2520)warpsNbt);
        ((Consumer)this.warpsLoadEvent.invoker()).accept(this.warps);
    }

    public void save() {
        EssentialCommands.log(Level.INFO, "Saving world_data.dat (Spawn/Warps)...", new Object[0]);
        super.method_17919(this.worldDataFile);
        EssentialCommands.log(Level.INFO, "world_data.dat saved.", new Object[0]);
    }

    public class_2487 method_75(class_2487 tag) {
        class_2487 spawnNbt = this.spawnLocation != null ? this.spawnLocation.asNbt() : new class_2487();
        tag.method_10566(SPAWN_KEY, (class_2520)spawnNbt);
        class_2487 warpsNbt = new class_2487();
        this.warps.writeNbt(warpsNbt);
        tag.method_10566(WARPS_KEY, (class_2520)warpsNbt);
        return tag;
    }

    public void setWarp(String warpName, MinecraftLocation location, boolean requiresPermission) throws CommandSyntaxException {
        this.warps.putCommand(warpName, new WarpLocation(location, requiresPermission ? warpName : null, warpName));
        this.method_80();
        this.save();
    }

    public boolean delWarp(String warpName) {
        MinecraftLocation prevValue = (MinecraftLocation)this.warps.remove(warpName);
        this.method_80();
        this.save();
        return prevValue != null;
    }

    public WarpLocation getWarp(String warpName) {
        return (WarpLocation)this.warps.get(warpName);
    }

    public List<String> getWarpNames() {
        return this.warps.keySet().stream().toList();
    }

    public Stream<WarpLocation> getAccessibleWarps(class_3222 player) {
        Stream<WarpLocation> warpsStream = this.warps.values().stream();
        return EssentialCommands.CONFIG.USE_PERMISSIONS_API ? warpsStream.filter(loc -> loc.hasPermission(player)) : warpsStream;
    }

    public Set<Map.Entry<String, WarpLocation>> getWarpEntries() {
        return this.warps.entrySet();
    }

    public void setSpawn(MinecraftLocation location) {
        this.spawnLocation = location;
        this.method_80();
        this.save();
    }

    public Optional<MinecraftLocation> getSpawn() {
        return Optional.ofNullable(this.spawnLocation);
    }
}

