/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands.suggestions;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class OfflinePlayerRepo {
    private final HashMap<String, GameProfile> gameProfileCache = new HashMap();
    private final MinecraftServer server;

    public OfflinePlayerRepo(MinecraftServer server) {
        this.server = server;
    }

    public CompletableFuture<class_3222> getOfflinePlayerByNameAsync(String playerName) {
        return this.getGameProfile(playerName).handle((gameProfile, throwable) -> gameProfile == null ? null : this.getOfflinePlayer((GameProfile)gameProfile));
    }

    public class_3222 getOfflinePlayer(GameProfile playerProfile) {
        class_3222 player = new class_3222(this.server, this.server.method_30002(), playerProfile);
        this.server.method_3760().method_14600(player);
        return player;
    }

    public CompletableFuture<GameProfile> getGameProfile(String playerName) {
        GameProfile profile = this.gameProfileCache.get(playerName);
        if (profile != null) {
            CompletableFuture.completedFuture(profile);
        }
        return this.requestGameProfile(playerName).whenComplete((gameProfile, err) -> {
            if (gameProfile != null) {
                this.gameProfileCache.put(gameProfile.getName(), (GameProfile)gameProfile);
            }
        });
    }

    private CompletableFuture<GameProfile> requestGameProfile(String playerName) {
        final CompletableFuture<GameProfile> out = new CompletableFuture<GameProfile>();
        this.server.method_3719().findProfilesByNames(new String[]{playerName}, Agent.MINECRAFT, new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile profile) {
                System.out.println(profile.toString());
                out.complete(profile);
            }

            public void onProfileLookupFailed(GameProfile profile, Exception exception) {
                out.complete(null);
            }
        });
        return out;
    }
}

