/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.WorldDataManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public final class ECPerms {
    private ECPerms() {
    }

    static void init() {
        WorldDataManager worldDataManager = ManagerLocator.getInstance().getWorldDataManager();
        Registry.per_warp_permissions = (String[])worldDataManager.getWarpNames().toArray(String[]::new);
        worldDataManager.warpsLoadEvent.register(warps -> {
            Registry.per_warp_permissions = (String[])warps.keySet().toArray(String[]::new);
        });
    }

    private static boolean isSuperAdmin(class_2172 source) {
        return source.method_9259(4);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, int defaultRequireLevel) {
        return player -> ECPerms.check((class_2172)player, permission, defaultRequireLevel);
    }

    @NotNull
    public static Predicate<class_2168> requireAny(@NotNull String[] permissions, int defaultRequireLevel) {
        return player -> ECPerms.checkAny((class_2172)player, permissions, defaultRequireLevel);
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission, int defaultRequireLevel) {
        if (EssentialCommands.CONFIG.USE_PERMISSIONS_API) {
            try {
                return Permissions.getPermissionValue((class_2172)source, (String)permission).orElse(source.method_9259(Math.max(2, defaultRequireLevel)));
            }
            catch (Exception e) {
                EssentialCommands.LOGGER.error((Object)e);
                return false;
            }
        }
        return source.method_9259(defaultRequireLevel);
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission) {
        return ECPerms.check(source, permission, 4);
    }

    public static boolean checkAny(@NotNull class_2172 source, @NotNull String[] permissions, int defaultRequireLevel) {
        for (String permission : permissions) {
            if (!ECPerms.check(source, permission, defaultRequireLevel)) continue;
            return true;
        }
        return false;
    }

    private static int getNumericValue(String permission) {
        return Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1));
    }

    public static int getHighestNumericPermission(@NotNull class_2172 source, @NotNull String[] permissionGroup) {
        if (ECPerms.isSuperAdmin(source)) {
            return Integer.MAX_VALUE;
        }
        if (permissionGroup.length == 1 && ECPerms.getNumericValue(permissionGroup[0]) == -1) {
            return Integer.MAX_VALUE;
        }
        if (!EssentialCommands.CONFIG.USE_PERMISSIONS_API) {
            return Arrays.stream(permissionGroup).mapToInt(ECPerms::getNumericValue).min().getAsInt();
        }
        int highestValue = EssentialCommands.CONFIG.GRANT_LOWEST_NUMERIC_BY_DEFAULT ? Arrays.stream(permissionGroup).mapToInt(ECPerms::getNumericValue).min().getAsInt() : -1;
        for (String permission : permissionGroup) {
            if (!ECPerms.check(source, permission)) continue;
            highestValue = Math.max(highestValue, ECPerms.getNumericValue(permission));
        }
        return highestValue;
    }

    public static String[] makeNumericPermissionGroup(String basePermission, Collection<Integer> numericValues) {
        Object trueBasePermission = basePermission.endsWith(".") ? basePermission : basePermission + ".";
        return (String[])numericValues.stream().map(arg_0 -> ECPerms.lambda$makeNumericPermissionGroup$5((String)trueBasePermission, arg_0)).toArray(String[]::new);
    }

    public static Stream<String> getGrantedStatefulPlayerAbilityPermissions(class_3222 player) {
        Stream<String> list = Arrays.stream(Registry.Group.stateful_player_abilities);
        return player.method_5687(2) ? list : list.filter(permission -> ECPerms.check((class_2172)player.method_5671(), permission));
    }

    private static /* synthetic */ String lambda$makeNumericPermissionGroup$5(String trueBasePermission, Integer el) {
        return trueBasePermission.concat(el.toString());
    }

    public static final class Registry {
        public static final String tpa = "essentialcommands.tpa";
        public static final String tpahere = "essentialcommands.tpahere";
        public static final String tpaccept = "essentialcommands.tpaccept";
        public static final String tpdeny = "essentialcommands.tpdeny";
        public static final String home_set = "essentialcommands.home.set";
        public static final String home_tp = "essentialcommands.home.tp";
        public static final String home_tp_others = "essentialcommands.home_tp_others";
        public static final String home_delete = "essentialcommands.home.delete";
        public static final String warp_set = "essentialcommands.warp.set";
        public static final String warp_tp = "essentialcommands.warp.tp";
        public static final String warp_delete = "essentialcommands.warp.delete";
        public static final String warp_tp_named = "essentialcommands.warp.tp_named";
        public static final String warp_tp_others = "essentialcommands.warp_tp_others";
        public static final String back = "essentialcommands.back";
        public static final String spawn_tp = "essentialcommands.spawn.tp";
        public static final String spawn_set = "essentialcommands.spawn.set";
        public static final String nickname_self = "essentialcommands.nickname.self";
        public static final String nickname_others = "essentialcommands.nickname.others";
        public static final String nickname_reveal = "essentialcommands.nickname.reveal";
        public static final String nickname_style_color = "essentialcommands.nickname.style.color";
        public static final String nickname_style_fancy = "essentialcommands.nickname.style.fancy";
        public static final String nickname_style_hover = "essentialcommands.nickname.style.hover";
        public static final String nickname_style_click = "essentialcommands.nickname.style.click";
        public static final String nickname_selector_and_ctx = "essentialcommands.nickname.style.selector_and_context";
        public static final String nickname_placeholders = "essentialcommands.nickname.placeholders";
        public static final String randomteleport = "essentialcommands.randomteleport";
        public static final String fly_self = "essentialcommands.fly.self";
        public static final String fly_others = "essentialcommands.fly.others";
        public static final String invuln_self = "essentialcommands.invuln.self";
        public static final String invuln_others = "essentialcommands.invuln.others";
        public static final String workbench = "essentialcommands.workbench";
        public static final String stonecutter = "essentialcommands.stonecutter";
        public static final String grindstone = "essentialcommands.grindstone";
        public static final String anvil = "essentialcommands.anvil";
        public static final String enderchest = "essentialcommands.enderchest";
        public static final String wastebin = "essentialcommands.wastebin";
        public static final String top = "essentialcommands.top";
        public static final String gametime = "essentialcommands.gametime";
        public static final String time_set_day = "essentialcommands.day";
        public static final String afk = "essentialcommands.afk";
        public static final String bed = "essentialcommands.bed";
        public static final String config_reload = "essentialcommands.config.reload";
        public static final String bypass_teleport_delay = "essentialcommands.bypass.teleport_delay";
        public static final String bypass_allow_teleport_between_dimensions = "essentialcommands.bypass.allow_teleport_between_dimensions";
        public static final String bypass_teleport_interrupt_on_damaged = "essentialcommands.bypass.teleport_interrupt_on_damaged";
        public static final String bypass_teleport_interrupt_on_move = "essentialcommands.bypass.teleport_interrupt_on_move";
        public static final String bypass_randomteleport_cooldown = "essentialcommands.bypass.randomteleport_cooldown";
        public static final String rules_reload = "essentialcommands.rules_reload";
        public static final String rules = "essentialcommands.rules";
        public static final String feed_self = "essentialcommands.feed.self";
        public static final String feed_others = "essentialcommands.feed.others";
        public static final String heal_self = "essentialcommands.heal.self";
        public static final String heal_others = "essentialcommands.heal.others";
        public static final String extinguish_self = "essentialcommands.extinguish.self";
        public static final String extinguish_others = "essentialcommands.extinguish.others";
        public static final String suicide = "essentialcommands.suicide";
        public static final String time_set_night = "essentialcommands.night";
        public static final String repair_self = "essentialcommands.repair.self";
        public static final String repair_others = "essentialcommands.repair.others";
        public static final String near_self = "essentialcommands.near.self";
        public static final String near_others = "essentialcommands.near.others";
        public static final String motd = "essentialcommands.motd";
        public static String[] per_warp_permissions = null;

        public static final class Group {
            public static final String[] tpa_group = new String[]{"essentialcommands.tpa", "essentialcommands.tpahere", "essentialcommands.tpaccept", "essentialcommands.tpdeny"};
            public static final String[] home_group = new String[]{"essentialcommands.home.set", "essentialcommands.home.tp", "essentialcommands.home.delete"};
            public static final String[] warp_group = new String[]{"essentialcommands.warp.set", "essentialcommands.warp.tp", "essentialcommands.warp.delete"};
            public static final String[] spawn_group = new String[]{"essentialcommands.spawn.tp", "essentialcommands.spawn.set"};
            public static final String[] nickname_group = new String[]{"essentialcommands.nickname.self", "essentialcommands.nickname.others", "essentialcommands.nickname.reveal"};
            public static final String[] fly_group = new String[]{"essentialcommands.fly.self", "essentialcommands.fly.others"};
            public static final String[] invuln_group = new String[]{"essentialcommands.invuln.self", "essentialcommands.invuln.others"};
            public static final String[] config_group = new String[]{"essentialcommands.config.reload"};
            public static String[] home_limit_group;
            public static final String[] stateful_player_abilities;

            static {
                stateful_player_abilities = new String[]{Registry.fly_self, Registry.fly_others, Registry.invuln_self, Registry.invuln_others};
            }
        }
    }
}

