/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Level;

public final class PlayerProfileFactory {
    private PlayerProfileFactory() {
    }

    private static PlayerProfile create(class_3222 player, File playerDataFile) {
        PlayerProfile pData = new PlayerProfile(player, playerDataFile);
        boolean fileExisted = false;
        try {
            fileExisted = !playerDataFile.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (fileExisted && playerDataFile.length() != 0L) {
            try {
                pData.fromNbt(class_2507.method_30613((Path)playerDataFile.toPath(), (class_2505)class_2505.method_53898()));
            }
            catch (IOException e) {
                EssentialCommands.log(Level.WARN, "Failed to load essential_commands player profile for {}", player.method_5477().getString());
                e.printStackTrace();
            }
        } else {
            pData.method_80();
            pData.save((class_7225.class_7874)Objects.requireNonNull(player.method_5682()).method_30611());
        }
        return pData;
    }

    public static PlayerProfile create(class_3222 player) {
        try {
            return PlayerProfileFactory.create(player, PlayerProfileFactory.getPlayerProfileFile(player));
        }
        catch (IOException ex) {
            EssentialCommands.log(Level.ERROR, "Failed to create player profile file for player with id '{}'. Player profile may fail to save, or other unexpected behavior may occur.", player.method_5845());
            EssentialCommands.LOGGER.error((Object)ex);
            return new PlayerProfile(player, null);
        }
    }

    private static File getPlayerProfileFile(class_3222 player) throws IOException {
        return FileUtil.getOrCreateWorldDirectory(player.method_5682(), "ec_player_profiles").resolve(player.method_5845() + ".dat").toFile();
    }
}

