/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.text;

import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.ECPlaceholderApiCompat;
import com.fibermc.essentialcommands.types.IStyleProvider;
import dev.jpcode.eccore.util.TextUtil;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ECTextImpl
extends ECText {
    private final ParserContext parserContext;

    public ECTextImpl(Map<String, String> stringMap, ParserContext parserContext) {
        super(stringMap);
        this.parserContext = parserContext;
    }

    public static ECText forServer(Map<String, String> stringMap, MinecraftServer server) {
        return new ECTextImpl(stringMap, ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)PlaceholderContext.of((MinecraftServer)server)));
    }

    @Override
    public String getString(String key) {
        return this.stringMap.getOrDefault(key, key);
    }

    public class_5250 getTextLiteral(String key, TextFormatType textFormatType) {
        return this.getTextLiteral(key, textFormatType, null);
    }

    public class_5250 getTextLiteral(String key, TextFormatType textFormatType, @Nullable IStyleProvider styleProvider) {
        return class_2561.method_43470((String)this.getString(key)).method_10862(styleProvider == null ? textFormatType.getStyle() : styleProvider.getStyle(textFormatType));
    }

    @Override
    public class_5250 getText(String key, class_2561 ... args) {
        return this.getTextInternal(key, TextFormatType.Default, null, args);
    }

    @Override
    public class_5250 getText(String key, TextFormatType textFormatType, class_2561 ... args) {
        return this.getTextInternal(key, textFormatType, null, args);
    }

    @Override
    public class_5250 getText(String key, TextFormatType textFormatType, IStyleProvider styleProvider, class_2561 ... args) {
        return this.getTextInternal(key, textFormatType, styleProvider, args);
    }

    private Placeholders.PlaceholderGetter placeholderGetterForContext(final TextFormatType textFormatType, final @Nullable IStyleProvider styleProvider, final List<class_5250> args) {
        return new Placeholders.PlaceholderGetter(){

            public boolean isContextOptional() {
                return true;
            }

            public PlaceholderHandler getPlaceholder(String placeholderId) {
                return (ctx, abc) -> {
                    String firstToken;
                    String[] idxAndFormattingCode = placeholderId.split(":");
                    if (idxAndFormattingCode.length < 1) {
                        throw new IllegalArgumentException("lang string placeholder did not contain an index");
                    }
                    class_5250 text = switch (firstToken = idxAndFormattingCode[0]) {
                        case "l" -> {
                            if (idxAndFormattingCode.length < 2) {
                                throw new IllegalArgumentException("Specified lang interpolation prefix ('l'), but no lang key was provided. Expected the form: 'l:lang.key.here'. Received: " + placeholderId);
                            }
                            yield ECTextImpl.this.getTextInternal(idxAndFormattingCode[1], textFormatType, styleProvider, new class_2561[0]);
                        }
                        default -> (class_5250)args.get(Integer.parseInt(idxAndFormattingCode[0]));
                    };
                    return PlaceholderResult.value((class_2561)text);
                };
            }
        };
    }

    private static int hashText(class_2561 text) {
        return Objects.hash(text.method_10851(), text.method_10866());
    }

    public class_5250 getTextInternal(String key, TextFormatType textFormatType, @Nullable IStyleProvider styleProvider, class_2561 ... args) {
        class_2583 specifiedStyle;
        List<class_5250> argsList = Arrays.stream(args).map(class_2561::method_27661).toList();
        HashSet argsHashes = argsList.stream().map(ECTextImpl::hashText).collect(Collectors.toCollection(HashSet::new));
        Placeholders.PlaceholderGetter placeholderGetter = this.placeholderGetterForContext(textFormatType, styleProvider, argsList);
        ParentNode nodes = Placeholders.parseNodes((TextNode)TextNode.convert((class_2561)class_2561.method_43470((String)this.getString(key))), (Pattern)Placeholders.PREDEFINED_PLACEHOLDER_PATTERN, (Placeholders.PlaceholderGetter)placeholderGetter);
        class_2561 retVal = ECPlaceholderApiCompat.toText(nodes, this.parserContext);
        List retValSiblings = retVal.method_10855();
        class_2583 class_25832 = specifiedStyle = styleProvider == null ? textFormatType.getStyle() : styleProvider.getStyle(textFormatType);
        if (retValSiblings.size() == 0) {
            return retVal.method_27661().method_10862(specifiedStyle);
        }
        return (class_5250)retValSiblings.stream().map(text -> argsHashes.contains(ECTextImpl.hashText(text)) ? text : text.method_27661().method_10862(specifiedStyle)).collect(TextUtil.collect());
    }

    @Override
    public boolean hasTranslation(String key) {
        return this.stringMap.containsKey(key);
    }

    @Override
    public boolean isRightToLeft() {
        return false;
    }

    @Override
    public class_5481 reorder(class_5348 text) {
        return visitor -> text.method_27658((style, string) -> class_5223.method_27479((String)string, (class_2583)style, (class_5224)visitor) ? Optional.empty() : class_5348.field_25309, class_2583.field_24360).isPresent();
    }
}

