/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.text.TextFormatType;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class MinecraftLocation {
    private class_243 pos;
    private float pitch;
    private float headYaw;
    private class_5321<class_1937> dim;

    protected MinecraftLocation() {
    }

    public MinecraftLocation(class_5321<class_1937> dim, double x, double y, double z) {
        this.dim = dim;
        this.pos = new class_243(x, y, z);
        this.pitch = 0.0f;
        this.headYaw = 0.0f;
    }

    public MinecraftLocation(class_5321<class_1937> dim, double x, double y, double z, float headYaw, float pitch) {
        this.dim = dim;
        this.pos = new class_243(x, y, z);
        this.headYaw = headYaw;
        this.pitch = pitch;
    }

    public MinecraftLocation(class_5321<class_1937> dim, class_2382 vec3i, float headYaw, float pitch) {
        this.dim = dim;
        this.pos = class_243.method_24953((class_2382)vec3i);
        this.headYaw = headYaw;
        this.pitch = pitch;
    }

    public MinecraftLocation(class_3222 player) {
        this.dim = player.method_37908().method_27983();
        this.pos = class_243.field_1353.method_1019(player.method_19538());
        this.headYaw = player.method_5791();
        this.pitch = player.method_36455();
    }

    public MinecraftLocation(class_2487 tag) {
        this.dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)((String)tag.method_10558("WorldRegistryKey").orElseThrow())));
        this.pos = new class_243(((Double)tag.method_10574("x").orElseThrow()).doubleValue(), ((Double)tag.method_10574("y").orElseThrow()).doubleValue(), ((Double)tag.method_10574("z").orElseThrow()).doubleValue());
        this.headYaw = tag.method_10583("headYaw").orElse(Float.valueOf(0.0f)).floatValue();
        this.pitch = tag.method_10583("pitch").orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static MinecraftLocation fromNbt(class_2487 tag) {
        MinecraftLocation loc = new MinecraftLocation();
        loc.loadNbt(tag);
        return loc;
    }

    protected void loadNbt(class_2487 tag) {
        this.dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)((String)tag.method_10558("WorldRegistryKey").orElseThrow())));
        this.pos = new class_243(((Double)tag.method_10574("x").orElseThrow()).doubleValue(), ((Double)tag.method_10574("y").orElseThrow()).doubleValue(), ((Double)tag.method_10574("z").orElseThrow()).doubleValue());
        this.headYaw = tag.method_10583("headYaw").orElse(Float.valueOf(0.0f)).floatValue();
        this.pitch = tag.method_10583("pitch").orElse(Float.valueOf(0.0f)).floatValue();
    }

    public class_2487 asNbt() {
        return this.writeNbt(new class_2487());
    }

    public class_2487 writeNbt(class_2487 tag) {
        tag.method_10582("WorldRegistryKey", this.dim().method_29177().toString());
        tag.method_10549("x", this.pos().field_1352);
        tag.method_10549("y", this.pos().field_1351);
        tag.method_10549("z", this.pos().field_1350);
        tag.method_10548("headYaw", this.headYaw());
        tag.method_10548("pitch", this.pitch());
        return tag;
    }

    protected class_5250 toLiteralTextSimple() {
        return class_2561.method_43470((String)String.format("(%.1f, %.1f, %.1f)", this.pos().field_1352, this.pos().field_1351, this.pos().field_1350));
    }

    public class_2561 toText(PlayerProfile playerProfile) {
        return this.toLiteralTextSimple().method_10862(playerProfile.getStyle(TextFormatType.Accent));
    }

    public class_243 pos() {
        return this.pos;
    }

    public class_2382 intPos() {
        return new class_2382((int)this.pos.field_1352, (int)this.pos.field_1351, (int)this.pos.field_1350);
    }

    public float pitch() {
        return this.pitch;
    }

    public float headYaw() {
        return this.headYaw;
    }

    public class_5321<class_1937> dim() {
        return this.dim;
    }
}

