/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import java.util.Optional;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class WarpLocation
extends NamedMinecraftLocation {
    private String permissionString;

    private WarpLocation() {
    }

    public WarpLocation(NamedMinecraftLocation location, String permissionString) {
        super(location, location.getName());
        this.permissionString = permissionString;
    }

    public WarpLocation(MinecraftLocation location, String permissionString, String name) {
        super(location, name);
        this.permissionString = permissionString;
    }

    public static WarpLocation fromNbt(class_2487 tag, String name) {
        tag = tag.method_10562("data").orElse(tag);
        WarpLocation loc = new WarpLocation();
        loc.loadNbt(tag, name);
        loc.permissionString = tag.method_10558("permissionString").flatMap(str -> str.isBlank() ? Optional.empty() : Optional.of(str)).orElse(null);
        return loc;
    }

    @Override
    public class_2487 asNbt() {
        return this.writeNbt(new class_2487());
    }

    @Override
    public class_2487 writeNbt(class_2487 tag) {
        super.writeNbt(tag);
        if (this.permissionString != null) {
            tag.method_10582("permissionString", this.permissionString);
        }
        return tag;
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public boolean hasPermission(class_3222 player) {
        return this.permissionString == null || ECPerms.check((class_2172)player.method_64396(), String.format("%s.%s", "essentialcommands.warp.tp_named", this.permissionString));
    }
}

