/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.fibermc.essentialcommands.types.NbtSerializable;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class NamedLocationStorage
extends HashMap<String, NamedMinecraftLocation>
implements NbtSerializable {
    public NamedLocationStorage() {
    }

    public NamedLocationStorage(class_2487 nbt) {
        this();
        this.loadNbt((class_2520)nbt);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        this.forEach((key, value) -> nbt.method_10566(key, (class_2520)value.asNbt()));
        return nbt;
    }

    public void loadNbt(class_2520 nbt) {
        if (nbt.method_10711() == 9) {
            class_2499 homesNbtList = (class_2499)nbt;
            for (class_2520 t : homesNbtList) {
                class_2487 homeTag = (class_2487)t;
                homeTag.method_10558("homeName").ifPresent(homeName -> super.put(homeName, NamedMinecraftLocation.fromNbt(homeTag, homeName)));
            }
        } else {
            class_2487 nbtCompound = (class_2487)nbt;
            nbtCompound.method_10541().forEach((? super T key) -> super.put(key, NamedMinecraftLocation.fromNbt(nbtCompound.method_68568(key), key)));
        }
    }

    public MinecraftLocation putCommand(String name, MinecraftLocation location) throws CommandSyntaxException {
        return this.putCommand(name, new NamedMinecraftLocation(location, name));
    }

    private MinecraftLocation putCommand(String name, NamedMinecraftLocation location) throws CommandSyntaxException {
        if (this.get(name) == null) {
            return super.put(name, location);
        }
        throw CommandUtil.createSimpleException((Message)ECText.getInstance().getText("cmd.home.set.error.exists", TextFormatType.Error, new class_2561[]{class_2561.method_43470((String)name)}));
    }
}

