/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.util;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.WorldDataManager;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public final class EssentialsConvertor {
    private static final Yaml YAML_INSTANCE = new Yaml();
    private static final Map<String, String> COMPARISON_TABLE = new HashMap<String, String>(){
        {
            this.put("world", "minecraft:overworld");
            this.put("world_nether", "minecraft:the_nether");
            this.put("world_the_end", "minecraft:the_end");
        }
    };
    public static final Path OLD_USERDATA_PATH = Path.of("./config", "EssentialCommands", "Old-Config", "UsersData");

    private EssentialsConvertor() {
    }

    @NotNull
    private static List<File> getAllFile(File dirFile) {
        ArrayList<File> files = new ArrayList<File>();
        if (Objects.isNull(dirFile) || !dirFile.exists() || dirFile.isFile()) {
            return files;
        }
        File[] childrenFiles = dirFile.listFiles();
        if (Objects.isNull(childrenFiles) || childrenFiles.length == 0) {
            return files;
        }
        for (File childFile : childrenFiles) {
            if (!childFile.isFile()) continue;
            files.add(childFile);
        }
        return files;
    }

    public static void homeConvert(MinecraftServer server) {
        List<File> oldUserDataFiles;
        File oldUsersDataDictionary = OLD_USERDATA_PATH.toFile();
        if (!oldUsersDataDictionary.exists() || oldUsersDataDictionary.isFile()) {
            oldUsersDataDictionary.mkdirs();
        }
        if ((oldUserDataFiles = EssentialsConvertor.getAllFile(oldUsersDataDictionary)).size() > 0) {
            EssentialCommands.LOGGER.info("Found the old home file(s), converting!");
            HashMap<String, class_3218> worldMap = new HashMap<String, class_3218>();
            int counter = 0;
            for (class_3218 world : server.method_3738()) {
                worldMap.put(world.method_27983().method_29177().toString(), world);
            }
            for (File oldUserDataFile : oldUserDataFiles) {
                try {
                    if (!oldUserDataFile.getName().contains("yaml") && !oldUserDataFile.getName().contains("yml") || oldUserDataFile.getName().contains(".converted")) continue;
                    Map data = (Map)YAML_INSTANCE.load((InputStream)new FileInputStream(oldUserDataFile));
                    if (data.containsKey("homes")) {
                        String playerName = (String)data.get("last-account-name");
                        Optional playerCache = server.method_3793().method_14515(playerName);
                        GameProfile playerProfile = new GameProfile(UUID.fromString(oldUserDataFile.getName().replaceAll(".yml", "").replaceAll(".yaml", "")), playerName);
                        Map homesMap = (Map)data.get("homes");
                        for (Map.Entry entry : homesMap.entrySet()) {
                            class_3218 world = (class_3218)worldMap.get(COMPARISON_TABLE.get((String)((Map)entry.getValue()).get("world-name")));
                            class_3222 player = new class_3222(server, world, playerProfile, class_8791.method_53821());
                            PlayerData playerData = ((ServerPlayerEntityAccess)player).ec$getPlayerData();
                            double x = (Double)((Map)entry.getValue()).get("x");
                            double y = (Double)((Map)entry.getValue()).get("y");
                            double z = (Double)((Map)entry.getValue()).get("z");
                            float yaw = (float)((Double)((Map)entry.getValue()).get("yaw")).doubleValue();
                            float pitch = (float)((Double)((Map)entry.getValue()).get("pitch")).doubleValue();
                            String homeName = (String)entry.getKey();
                            playerData.addHome(homeName, new MinecraftLocation((class_5321<class_1937>)world.method_27983(), x, y, z, yaw, pitch));
                            playerData.save((class_7225.class_7874)player.method_5682().method_30611());
                            oldUserDataFile.renameTo(new File(oldUsersDataDictionary, oldUserDataFile.getName() + ".converted"));
                            ++counter;
                        }
                        continue;
                    }
                    oldUserDataFile.renameTo(new File(oldUsersDataDictionary, oldUserDataFile.getName() + ".converted"));
                }
                catch (CommandSyntaxException ex) {
                    EssentialCommands.LOGGER.error("An unexpected error occurred while converting home config: {}", (Object)oldUserDataFile.getName());
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    EssentialCommands.LOGGER.error("An unexpected error occurred while converting home config: {}", (Object)oldUserDataFile.getName());
                    ex.printStackTrace();
                    return;
                }
            }
            EssentialCommands.LOGGER.info("Convert finished, converted " + counter + " file(s)!");
        }
    }

    public static void warpConvert(MinecraftServer server, File essentialsXWarpsDirectory) {
        List<File> oldWarpFiles = EssentialsConvertor.getAllFile(essentialsXWarpsDirectory);
        if (oldWarpFiles.size() == 0) {
            EssentialCommands.LOGGER.info("Found 0 warps to convert in '{}'. Exiting.", (Object)essentialsXWarpsDirectory.getPath());
            return;
        }
        EssentialCommands.LOGGER.info("Found {} old warp file(s), converting!", (Object)oldWarpFiles.size());
        WorldDataManager worldDataManager = ManagerLocator.getInstance().getWorldDataManager();
        HashMap<String, class_1937> worldMap = new HashMap<String, class_1937>();
        HashMap<String, MinecraftLocation> locationMap = new HashMap<String, MinecraftLocation>();
        for (class_1937 world : server.method_3738()) {
            worldMap.put(world.method_27983().method_29177().toString(), world);
        }
        for (File oldWarpFile : oldWarpFiles) {
            try {
                if (!oldWarpFile.getName().endsWith("yaml") && !oldWarpFile.getName().endsWith("yml")) continue;
                Map data = (Map)YAML_INSTANCE.load((InputStream)new FileInputStream(oldWarpFile));
                double x = (Double)data.get("x");
                double y = (Double)data.get("y");
                double z = (Double)data.get("z");
                float yaw = (float)((Double)data.get("yaw")).doubleValue();
                float pitch = (float)((Double)data.get("pitch")).doubleValue();
                String worldName = (String)data.get("world-name");
                String warpName = (String)data.get("name");
                locationMap.put(warpName, new MinecraftLocation((class_5321<class_1937>)((class_1937)worldMap.get(COMPARISON_TABLE.get(worldName))).method_27983(), x, y, z, yaw, pitch));
            }
            catch (Exception e) {
                EssentialCommands.LOGGER.error("An unexpected error occurred while converting warp config: {}", (Object)oldWarpFile.getName());
                e.printStackTrace();
            }
        }
        int successfulConversionCount = 0;
        for (Map.Entry entry : locationMap.entrySet()) {
            try {
                worldDataManager.setWarp((String)entry.getKey(), (MinecraftLocation)entry.getValue(), false);
                ++successfulConversionCount;
            }
            catch (Exception e) {
                EssentialCommands.LOGGER.error("There was an error occurred while putting warp config: {}", entry.getKey());
                e.printStackTrace();
            }
        }
        EssentialCommands.LOGGER.info("Convert finished, successfully converted {} / {} file(s)!", (Object)successfulConversionCount, (Object)oldWarpFiles.size());
    }
}

