/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.util;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.mixin.PersistentStateManagerInvoker;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerDataFactory;
import com.fibermc.essentialcommands.types.NamedLocationStorage;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.yaml.snakeyaml.Yaml;

public final class EssentialsXParser {
    private EssentialsXParser() {
    }

    public static NamedLocationStorage parsePlayerHomes(File yamlSource, Map<UUID, class_5321<class_1937>> uuidRegistryKeyMap) {
        NamedLocationStorage homes = new NamedLocationStorage();
        String yamlStr = null;
        try {
            yamlStr = Files.readString(yamlSource.toPath());
        }
        catch (IOException e) {
            EssentialCommands.LOGGER.error("Error while reading yaml file {}", (Object)yamlSource);
            EssentialCommands.LOGGER.error("Err Detail:", (Throwable)e);
        }
        Yaml yaml = new Yaml();
        Map ydoc = (Map)yaml.load(yamlStr);
        Map homesMap = (Map)ydoc.get("homes");
        if (homesMap == null) {
            EssentialCommands.LOGGER.info("No homes key in file '{}'. Skipping.", (Object)yamlSource.toPath().toString());
            return homes;
        }
        EssentialCommands.LOGGER.info("Found {} homes in file '{}'.", (Object)homesMap.size(), (Object)yamlSource.toPath().toString());
        homesMap.forEach((name, locData) -> {
            String worldName;
            class_5321 worldRegistryKey;
            String worldIdentifier = (String)locData.get("world");
            UUID worldUuid = null;
            try {
                worldUuid = UUID.fromString(worldIdentifier);
                worldRegistryKey = (class_5321)uuidRegistryKeyMap.get(worldUuid);
            }
            catch (Exception ign) {
                switch (worldIdentifier) {
                    case "world": {
                        class_5321 class_53212 = class_1937.field_25179;
                        break;
                    }
                    case "world_nether": {
                        class_5321 class_53212 = class_1937.field_25180;
                        break;
                    }
                    case "world_the_end": {
                        class_5321 class_53212 = class_1937.field_25181;
                        break;
                    }
                    default: {
                        class_5321 class_53212 = worldRegistryKey = null;
                    }
                }
            }
            if (worldRegistryKey == null && (worldName = (String)locData.get("world-name")) != null) {
                worldRegistryKey = switch (worldName) {
                    case "world" -> {
                        if (worldUuid != null) {
                            uuidRegistryKeyMap.putIfAbsent(worldUuid, class_1937.field_25179);
                        }
                        yield class_1937.field_25179;
                    }
                    case "world_nether" -> {
                        if (worldUuid != null) {
                            uuidRegistryKeyMap.putIfAbsent(worldUuid, class_1937.field_25180);
                        }
                        yield class_1937.field_25180;
                    }
                    case "world_the_end" -> {
                        if (worldUuid != null) {
                            uuidRegistryKeyMap.putIfAbsent(worldUuid, class_1937.field_25181);
                        }
                        yield class_1937.field_25181;
                    }
                    default -> class_1937.field_25179;
                };
            }
            homes.put(name, new NamedMinecraftLocation((class_5321<class_1937>)worldRegistryKey, (Double)locData.get("x"), (Double)locData.get("y"), (Double)locData.get("z"), ((Double)locData.get("yaw")).floatValue(), ((Double)locData.get("pitch")).floatValue(), (String)name));
        });
        return homes;
    }

    public static Map<UUID, class_5321<class_1937>> getWorldUids(MinecraftServer server) {
        LinkedHashMap<UUID, class_5321<class_1937>> uuidRegistryKeyMap = new LinkedHashMap<UUID, class_5321<class_1937>>();
        server.method_3738().forEach(world -> {
            PersistentStateManagerInvoker persistentStateManager = (PersistentStateManagerInvoker)world.method_17983();
            File uidFile = persistentStateManager.invokeGetFile("uid").toFile();
            if (!uidFile.exists()) {
                uidFile = persistentStateManager.invokeGetFile("../uid").toFile();
            }
            try {
                EssentialCommands.LOGGER.info(String.format("Attempting to read file: %s", uidFile.getPath()));
                byte[] uuidBytes = Files.readAllBytes(uidFile.toPath());
                EssentialCommands.LOGGER.info(String.format("File: %s, UUID: %s", uidFile.getPath(), UUID.nameUUIDFromBytes(uuidBytes)));
                uuidRegistryKeyMap.put(UUID.nameUUIDFromBytes(uuidBytes), world.method_27983());
            }
            catch (IOException e) {
                EssentialCommands.LOGGER.log(Level.WARN, String.format("World, %s, did not have a valid uid.dat file. EssentialsX homes set in this dim will likely be remapped to %s.", world.method_27983().method_29177().toString(), class_1937.field_25179.method_29177().toString()));
            }
        });
        return uuidRegistryKeyMap;
    }

    public static void convertPlayerDataDir(File sourceDir, File targetDir, MinecraftServer server) throws NotDirectoryException, FileNotFoundException {
        if (!sourceDir.exists()) {
            throw new FileNotFoundException(sourceDir.getAbsolutePath() + " does not exist!");
        }
        if (!sourceDir.isDirectory()) {
            throw new NotDirectoryException(sourceDir.getAbsolutePath() + " is not a directory!");
        }
        Map<UUID, class_5321<class_1937>> worldUuidRegistryKeyMap = EssentialsXParser.getWorldUids(server);
        targetDir.mkdir();
        Path targetPath = targetDir.toPath();
        File[] filesArr = Objects.requireNonNull(sourceDir.listFiles());
        EssentialCommands.LOGGER.info("Preparing to convert homes for {} players in directory '{}'", (Object)filesArr.length, (Object)sourceDir);
        int filesAttempted = 0;
        int filesSucceeded = 0;
        List<File> playerDataFiles = Arrays.stream(filesArr).filter(file -> file.getName().endsWith("yml")).toList();
        for (File file2 : playerDataFiles) {
            ++filesAttempted;
            EssentialCommands.LOGGER.info("Begin parsing homes for '{}'", (Object)file2);
            String fileName = file2.getName();
            String fileNameAsDat = fileName.substring(0, fileName.indexOf(".yml")) + ".dat";
            String targetFilePathStr = targetPath.resolve(fileNameAsDat).toString();
            File targetFile = new File(targetFilePathStr);
            try {
                NamedLocationStorage homes = EssentialsXParser.parsePlayerHomes(file2, worldUuidRegistryKeyMap);
                EssentialCommands.LOGGER.info("Creating temporary playerdata for '{}', with {} homes.", (Object)file2, (Object)homes.size());
                PlayerData playerData = PlayerDataFactory.create(homes, targetFile);
                playerData.save((class_7225.class_7874)class_5455.field_40585);
                ++filesSucceeded;
            }
            catch (Exception ex) {
                EssentialCommands.LOGGER.error("An unexpected error occurred while parsing player data file '{}'", (Object)targetFile.getPath(), (Object)ex);
            }
        }
        EssentialCommands.LOGGER.info("Finished converting EssentialsX homes to EssentialCommands homes. (Players Attempted: {}, Players Succeeded: {})", (Object)filesAttempted, (Object)filesSucceeded);
    }
}

