/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.text;

import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.IStyleProvider;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ECTextImpl
extends ECText {
    private final ParserContext parserContext;
    private static final class_2583 DEFAULT_ARGUMENT_STYLE = class_2583.field_24360.method_10977(class_124.field_1068);

    public ECTextImpl(Map<String, String> stringMap, ParserContext parserContext) {
        super(stringMap);
        this.parserContext = parserContext;
    }

    public static ECText forServer(Map<String, String> stringMap, MinecraftServer server) {
        return new ECTextImpl(stringMap, ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)PlaceholderContext.of((MinecraftServer)server)));
    }

    @Override
    public String getString(String key) {
        return this.stringMap.getOrDefault(key, key);
    }

    public class_5250 getTextLiteral(String key, TextFormatType textFormatType) {
        return this.getTextLiteral(key, textFormatType, null);
    }

    public class_5250 getTextLiteral(String key, TextFormatType textFormatType, @Nullable IStyleProvider styleProvider) {
        return class_2561.method_43470((String)this.getString(key)).method_10862(styleProvider == null ? textFormatType.getStyle() : styleProvider.getStyle(textFormatType));
    }

    @Override
    public class_5250 getText(String key, class_2561 ... args) {
        return this.getTextInternal(key, TextFormatType.Default, null, args);
    }

    @Override
    public class_5250 getText(String key, TextFormatType textFormatType, class_2561 ... args) {
        return this.getTextInternal(key, textFormatType, null, args);
    }

    @Override
    public class_5250 getText(String key, TextFormatType textFormatType, IStyleProvider styleProvider, class_2561 ... args) {
        return this.getTextInternal(key, textFormatType, styleProvider, args);
    }

    private NodeParser parserForContext(TextFormatType textFormatType, @Nullable IStyleProvider styleProvider, List<class_5250> args) {
        return TagLikeParser.of((TagLikeParser.Format)TagLikeParser.PLACEHOLDER_USER, (TagLikeParser.Provider)TagLikeParser.Provider.placeholderText(placeholderId -> {
            if (placeholderId.startsWith("l:")) {
                String[] idxAndFormattingCode = placeholderId.split(":");
                if (idxAndFormattingCode.length < 2) {
                    throw new IllegalArgumentException("Specified lang interpolation prefix ('l'), but no lang key was provided. Expected the form: 'l:lang.key.here'. Received: " + placeholderId);
                }
                if (idxAndFormattingCode.length > 3) {
                    throw new IllegalArgumentException("lang string placeholder had an unexpected second ':'. Received: " + placeholderId);
                }
                return this.getTextInternal(idxAndFormattingCode[1], textFormatType, styleProvider, new class_2561[0]);
            }
            if (placeholderId.matches("\\d+")) {
                int targetIndex = Integer.parseInt(placeholderId);
                if (targetIndex > args.size()) {
                    throw new IllegalArgumentException("Invalid 'Argument' placeholder: targeted argument with (0-based) index '" + targetIndex + "' but only " + args.size() + " were present");
                }
                return (class_2561)args.get(targetIndex);
            }
            return null;
        }));
    }

    private static int hashText(class_2561 text) {
        return Objects.hash(text.method_10851(), text.method_10866());
    }

    public class_5250 getTextInternal(String key, TextFormatType textFormatType, @Nullable IStyleProvider styleProvider, class_2561 ... args) {
        List<class_5250> argsList = Arrays.stream(args).map(class_2561::method_27661).toList();
        HashSet argsHashes = argsList.stream().map(ECTextImpl::hashText).collect(Collectors.toCollection(HashSet::new));
        NodeParser parser = this.parserForContext(textFormatType, styleProvider, argsList);
        class_2561 parsedText = parser.parseText(this.getString(key), this.parserContext);
        class_2583 specifiedStyle = styleProvider == null ? textFormatType.getStyle() : styleProvider.getStyle(textFormatType);
        return this.visitText(parsedText, this.defaultStylesVisitor(node -> argsHashes.contains(ECTextImpl.hashText(node)) ? DEFAULT_ARGUMENT_STYLE : specifiedStyle), node -> argsHashes.contains(ECTextImpl.hashText(node)));
    }

    TextVisitor defaultStylesVisitor(Function<class_2561, @Nullable class_2583> defaultStyleProvider) {
        return text -> {
            class_5250 txt = text.method_27661();
            class_2583 defaultStyleForText = (class_2583)defaultStyleProvider.apply((class_2561)txt);
            if (defaultStyleForText != null) {
                txt.method_10862(txt.method_10866().method_27702(defaultStyleForText));
            }
            return txt;
        };
    }

    class_5250 visitText(class_2561 root, TextVisitor textVisitor, Predicate<class_2561> shouldStopAfter) {
        class_5250 txt = textVisitor.accept(root);
        if (shouldStopAfter.test(root)) {
            return txt;
        }
        List siblings = txt.method_10855();
        for (int i = 0; i < siblings.size(); ++i) {
            siblings.set(i, this.visitText((class_2561)siblings.get(i), textVisitor, shouldStopAfter));
        }
        return txt;
    }

    @Override
    public boolean hasTranslation(String key) {
        return this.stringMap.containsKey(key);
    }

    @Override
    public boolean isRightToLeft() {
        return false;
    }

    @Override
    public class_5481 reorder(class_5348 text) {
        return visitor -> text.method_27658((style, string) -> class_5223.method_27479((String)string, (class_2583)style, (class_5224)visitor) ? Optional.empty() : class_5348.field_25309, class_2583.field_24360).isPresent();
    }

    static interface TextVisitor {
        public class_5250 accept(class_2561 var1);
    }
}

