/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.codec;

import com.fibermc.essentialcommands.WorldData;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedLocationStorage;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.fibermc.essentialcommands.types.WarpLocation;
import com.fibermc.essentialcommands.types.WarpStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public final class Codecs {
    public static final Codec<class_5321<class_1937>> WORLD_KEY = class_5321.method_39154((class_5321)class_7924.field_41223);
    public static final Codec<MinecraftLocation> MINECRAFT_LOCATION = RecordCodecBuilder.create(instance -> instance.group((App)WORLD_KEY.fieldOf("WorldRegistryKey").forGetter(MinecraftLocation::dim), (App)Codec.DOUBLE.fieldOf("x").forGetter(MinecraftLocation::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(MinecraftLocation::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(MinecraftLocation::z), (App)Codec.FLOAT.optionalFieldOf("headYaw", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::headYaw), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::pitch)).apply((Applicative)instance, MinecraftLocation::new));
    public static final Codec<NamedMinecraftLocation> NAMED_MINECRAFT_LOCATION = RecordCodecBuilder.create(instance -> instance.group((App)WORLD_KEY.fieldOf("WorldRegistryKey").forGetter(MinecraftLocation::dim), (App)Codec.DOUBLE.fieldOf("x").forGetter(MinecraftLocation::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(MinecraftLocation::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(MinecraftLocation::z), (App)Codec.FLOAT.optionalFieldOf("headYaw", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::headYaw), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::pitch), (App)Codec.STRING.optionalFieldOf("name").forGetter(home -> Optional.of(home.getName()))).apply((Applicative)instance, NamedMinecraftLocation::new));
    public static final Codec<WarpLocation> WARP_LOCATION = RecordCodecBuilder.create(instance -> instance.group((App)WORLD_KEY.fieldOf("WorldRegistryKey").forGetter(MinecraftLocation::dim), (App)Codec.DOUBLE.fieldOf("x").forGetter(MinecraftLocation::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(MinecraftLocation::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(MinecraftLocation::z), (App)Codec.FLOAT.optionalFieldOf("headYaw", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::headYaw), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(MinecraftLocation::pitch), (App)Codec.STRING.optionalFieldOf("name").forGetter(warp -> Optional.of(warp.getName())), (App)Codec.STRING.optionalFieldOf("permissionString").forGetter(warp -> Optional.ofNullable(warp.getPermissionString()))).apply((Applicative)instance, WarpLocation::new));
    public static final Codec<NamedLocationStorage> NAMED_LOCATION_STORAGE = Codec.unboundedMap((Codec)Codec.STRING, NAMED_MINECRAFT_LOCATION).xmap(map -> {
        NamedLocationStorage storage = new NamedLocationStorage();
        map.forEach((key, value) -> storage.put(key, new NamedMinecraftLocation((MinecraftLocation)value, (String)key)));
        return storage;
    }, HashMap::new);
    public static final Codec<WarpStorage> WARP_STORAGE = Codec.unboundedMap((Codec)Codec.STRING, WARP_LOCATION).xmap(map -> {
        WarpStorage storage = new WarpStorage();
        map.forEach((key, value) -> storage.put(key, WarpLocation.setName(value, key)));
        return storage;
    }, HashMap::new);
    public static final Codec<WorldData> WORLD_DATA = WorldData.CODEC;

    private Codecs() {
    }
}

