/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.codec.Codecs;
import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.fibermc.essentialcommands.types.NbtSerializable;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class NamedLocationStorage
extends HashMap<String, NamedMinecraftLocation>
implements NbtSerializable {
    public static final Codec<NamedLocationStorage> CODEC = Codecs.NAMED_LOCATION_STORAGE;

    public NamedLocationStorage() {
    }

    public NamedLocationStorage(class_2487 nbt) {
        this();
        this.loadNbt((class_2520)nbt);
    }

    public static NamedLocationStorage fromNbt(class_2487 nbt) {
        DataResult result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt);
        if (result.isSuccess()) {
            return (NamedLocationStorage)result.getOrThrow();
        }
        NamedLocationStorage storage = new NamedLocationStorage();
        storage.loadNbt((class_2520)nbt);
        return storage;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        return (class_2487)((class_2520)CODEC.encode((Object)this, (DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow()).method_68571().orElseThrow();
    }

    private void loadNbt(class_2520 nbt) {
        if (nbt.method_10711() == 9) {
            class_2499 homesNbtList = (class_2499)nbt;
            for (class_2520 t : homesNbtList) {
                class_2487 homeTag = (class_2487)t;
                homeTag.method_10558("homeName").ifPresent(homeName -> {
                    MinecraftLocation location = MinecraftLocation.fromNbt(homeTag);
                    super.put(homeName, new NamedMinecraftLocation(location, (String)homeName));
                });
            }
        } else {
            class_2487 nbtCompound = (class_2487)nbt;
            nbtCompound.method_10541().forEach((? super T key) -> {
                NamedMinecraftLocation location = NamedMinecraftLocation.fromNbt((class_2487)nbtCompound.method_10562(key).orElseThrow());
                if (!key.equals(location.getName())) {
                    throw new RuntimeException("Home key '%s' did not match home name '%s'".formatted(key, location.getName()));
                }
                super.put(key, location);
            });
        }
    }

    public MinecraftLocation putCommand(String name, MinecraftLocation location) throws CommandSyntaxException {
        return this.putCommand(name, new NamedMinecraftLocation(location, name));
    }

    private MinecraftLocation putCommand(String name, NamedMinecraftLocation location) throws CommandSyntaxException {
        if (this.get(name) == null) {
            return super.put(name, location);
        }
        throw CommandUtil.createSimpleException((Message)ECText.getInstance().getText("cmd.home.set.error.exists", TextFormatType.Error, new class_2561[]{class_2561.method_43470((String)name)}));
    }
}

