/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.types.Vec2i;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public sealed interface RtpCenter {
    public Optional<Vec2i> getPosition();

    public String serialize();

    public static Spawn spawn() {
        return new Spawn();
    }

    public static Coordinates coordinates(int x, int z) {
        return new Coordinates(new Vec2i(x, z));
    }

    public static RtpCenter parse(String serialized) {
        if (serialized == null || serialized.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot parse null or empty string");
        }
        String trimmed = serialized.trim();
        if ("SPAWN".equalsIgnoreCase(trimmed)) {
            return new Spawn();
        }
        Matcher matcher = Coordinates.REGEX.matcher(trimmed);
        if (matcher.matches()) {
            String xStr = matcher.group(1);
            String zStr = matcher.group(2);
            try {
                int x = Integer.parseInt(xStr);
                int y = Integer.parseInt(zStr);
                return new Coordinates(new Vec2i(x, y));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid coordinate numbers: ", e);
            }
        }
        throw new IllegalArgumentException("Unknown rtp_center format: " + serialized);
    }

    public record Spawn() implements RtpCenter
    {
        @Override
        public Optional<Vec2i> getPosition() {
            return Optional.empty();
        }

        @Override
        public String serialize() {
            return "Spawn";
        }
    }

    public record Coordinates(Vec2i position) implements RtpCenter
    {
        private static final Pattern REGEX = Pattern.compile("(?:COORDINATES)?\\(?\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)?", 2);

        @Override
        public Optional<Vec2i> getPosition() {
            return Optional.of(this.position);
        }

        @Override
        public String serialize() {
            return "Coordinates(" + this.position.x() + "," + this.position.z() + ")";
        }
    }
}

