/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.placeholders;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import java.util.Map;
import me.lucko.luckperms.placeholders.DynamicPlaceholder;
import me.lucko.luckperms.placeholders.LPPlaceholderProvider;
import me.lucko.luckperms.placeholders.Placeholder;
import me.lucko.luckperms.placeholders.PlaceholderPlatform;
import me.lucko.luckperms.placeholders.StaticPlaceholder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class LuckPermsFabricPlaceholders
implements ModInitializer,
PlaceholderPlatform {
    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.registerPlaceholders());
    }

    private void registerPlaceholders() {
        LuckPerms luckPerms = LuckPermsProvider.get();
        LPPlaceholderProvider provider = new LPPlaceholderProvider(this, luckPerms);
        Map<String, Placeholder> placeholders = provider.getPlaceholders();
        placeholders.forEach((s, placeholder) -> {
            String trimmed = s.replaceAll("_$", "");
            Placeholders.register((class_2960)new class_2960("luckperms", trimmed), (ctx, arg) -> {
                if (ctx.hasPlayer()) {
                    class_3222 player = ctx.player();
                    assert (player != null);
                    User user = luckPerms.getUserManager().getUser(player.method_5667());
                    if (user == null) {
                        return PlaceholderResult.invalid((String)"No user!");
                    }
                    CachedDataManager data = user.getCachedData();
                    QueryOptions queryOptions = luckPerms.getContextManager().getQueryOptions((Object)player);
                    Object result = null;
                    if (placeholder instanceof DynamicPlaceholder) {
                        DynamicPlaceholder dp = (DynamicPlaceholder)placeholder;
                        result = arg == null && placeholders.containsKey(trimmed) ? ((StaticPlaceholder)placeholders.get(trimmed)).handle(player, user, data, queryOptions) : dp.handle(player, user, data, queryOptions, arg);
                    } else if (placeholder instanceof StaticPlaceholder) {
                        StaticPlaceholder sp = (StaticPlaceholder)placeholder;
                        result = sp.handle(player, user, data, queryOptions);
                    }
                    if (result instanceof Boolean) {
                        result = this.formatBoolean((Boolean)result);
                    }
                    return result == null ? PlaceholderResult.invalid() : PlaceholderResult.value((class_2561)TextParserUtils.formatText((String)result.toString()));
                }
                return PlaceholderResult.invalid((String)"No player!");
            });
        });
    }
}

